%------------------------------------------------------------------------------
% File     : COM191^1 : TPTP v9.2.0. Released v7.0.0.
% Domain   : Computing Theory
% Problem  : Grammars and languages 882
% Version  : [Bla16] axioms : Especial.
% English  :

% Refs     : [BH+14] Blanchette et al. (2014), Truly Modular (Co)datatypes
%          : [RB15]  Reynolds & Blanchette (2015), A Decision Procedure for
%          : [Bla16] Blanchette (2016), Email to Geoff Sutcliffe
% Source   : [Bla16]
% Names    : gram_lang__882.p [Bla16]

% Status   : Theorem
% Rating   : 1.00 v9.1.0, 0.67 v8.1.0, 0.75 v7.5.0, 0.67 v7.2.0, 0.75 v7.1.0
% Syntax   : Number of formulae    :  333 ( 103 unt;  64 typ;   0 def)
%            Number of atoms       :  774 ( 247 equ;   0 cnn)
%            Maximal formula atoms :   13 (   2 avg)
%            Number of connectives : 3932 (  96   ~;  13   |;  86   &;3309   @)
%                                         (   0 <=>; 428  =>;   0  <=;   0 <~>)
%            Maximal formula depth :   21 (   8 avg)
%            Number of types       :    4 (   3 usr)
%            Number of type conns  :  240 ( 240   >;   0   *;   0   +;   0  <<)
%            Number of symbols     :   64 (  61 usr;  10 con; 0-6 aty)
%            Number of variables   : 1101 (  82   ^; 908   !;  58   ?;1101   :)
%                                         (  40  !>;   0  ?*;   0  @-;  13  @+)
% SPC      : TH1_THM_EQU_NAR

% Comments : This file was generated by Isabelle (most likely Sledgehammer)
%            2016-07-13 14:45:37.740
%------------------------------------------------------------------------------
%----Could-be-implicit typings (7)
thf(ty_t_Sum__Type_Osum,type,
    sum_sum: $tType > $tType > $tType ).

thf(ty_t_DTree_Odtree,type,
    dtree: $tType ).

thf(ty_t_List_Olist,type,
    list: $tType > $tType ).

thf(ty_t_Set_Oset,type,
    set: $tType > $tType ).

thf(ty_t_DTree_OT,type,
    t: $tType ).

thf(ty_t_DTree_ON,type,
    n: $tType ).

thf(ty_t_itself,type,
    itself: $tType > $tType ).

%----Explicit typings (57)
thf(sy_cl_HOL_Otype,type,
    type: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oord,type,
    ord: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Oorder,type,
    order: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Olinorder,type,
    linorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_cl_Orderings_Opreorder,type,
    preorder: 
      !>[A: $tType] : ( ( itself @ A ) > $o ) ).

thf(sy_c_BNF__Greatest__Fixpoint_Oshift,type,
    bNF_Greatest_shift: 
      !>[A: $tType,B: $tType] : ( ( ( list @ A ) > B ) > A > ( list @ A ) > B ) ).

thf(sy_c_BNF__Greatest__Fixpoint_Ouniv,type,
    bNF_Greatest_univ: 
      !>[B: $tType,A: $tType] : ( ( B > A ) > ( set @ B ) > A ) ).

thf(sy_c_DTree_ONode,type,
    node: n > ( set @ ( sum_sum @ t @ dtree ) ) > dtree ).

thf(sy_c_DTree_Ocont,type,
    cont: dtree > ( set @ ( sum_sum @ t @ dtree ) ) ).

thf(sy_c_DTree_Odtree_Oroot,type,
    root: dtree > n ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OItr,type,
    gram_L1580978439le_Itr: ( set @ n ) > dtree > ( set @ n ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Ohsubst__c,type,
    gram_L1905609002ubst_c: dtree > dtree > ( set @ ( sum_sum @ t @ dtree ) ) ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Ohsubst__r,type,
    gram_L1905609017ubst_r: dtree > n ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinFr,type,
    gram_L1333338417e_inFr: ( set @ n ) > dtree > t > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinFr2,type,
    gram_L805317441_inFr2: ( set @ n ) > dtree > t > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OinItr,type,
    gram_L830233218_inItr: ( set @ n ) > dtree > n > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Opath,type,
    gram_L250615845e_path: ( n > dtree ) > ( list @ n ) > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Oreg,type,
    gram_L1918716148le_reg: ( n > dtree ) > dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Oregular,type,
    gram_L646766332egular: dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Osubtr,type,
    gram_L716654942_subtr: ( set @ n ) > dtree > dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Osubtr2,type,
    gram_L1283001940subtr2: ( set @ n ) > dtree > dtree > $o ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_OsubtrOf,type,
    gram_L1614515765ubtrOf: dtree > n > dtree ).

thf(sy_c_Gram__Lang__Mirabelle__ojxrtuoybn_Owf,type,
    gram_L864798063lle_wf: dtree > $o ).

thf(sy_c_Hilbert__Choice_OGreatest,type,
    hilbert_Greatest: 
      !>[A: $tType] : ( ( A > $o ) > A ) ).

thf(sy_c_Hilbert__Choice_OGreatestM,type,
    hilbert_GreatestM: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( A > $o ) > A ) ).

thf(sy_c_Hilbert__Choice_OLeastM,type,
    hilbert_LeastM: 
      !>[A: $tType,B: $tType] : ( ( A > B ) > ( A > $o ) > A ) ).

thf(sy_c_If,type,
    if: 
      !>[A: $tType] : ( $o > A > A > A ) ).

thf(sy_c_List_Ocoset,type,
    coset: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Odistinct,type,
    distinct: 
      !>[A: $tType] : ( ( list @ A ) > $o ) ).

thf(sy_c_List_Oinsert,type,
    insert: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olast,type,
    last: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olist_OCons,type,
    cons: 
      !>[A: $tType] : ( A > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_List_Olist_ONil,type,
    nil: 
      !>[A: $tType] : ( list @ A ) ).

thf(sy_c_List_Olist_Ohd,type,
    hd: 
      !>[A: $tType] : ( ( list @ A ) > A ) ).

thf(sy_c_List_Olist_Oset,type,
    set2: 
      !>[A: $tType] : ( ( list @ A ) > ( set @ A ) ) ).

thf(sy_c_List_Oproduct__lists,type,
    product_lists: 
      !>[A: $tType] : ( ( list @ ( list @ A ) ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Osublists,type,
    sublists: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ ( list @ A ) ) ) ).

thf(sy_c_List_Ounion,type,
    union: 
      !>[A: $tType] : ( ( list @ A ) > ( list @ A ) > ( list @ A ) ) ).

thf(sy_c_Orderings_Oord__class_Oless__eq,type,
    ord_less_eq: 
      !>[A: $tType] : ( A > A > $o ) ).

thf(sy_c_Pure_Otype,type,
    type2: 
      !>[A: $tType] : ( itself @ A ) ).

thf(sy_c_Set_OCollect,type,
    collect: 
      !>[A: $tType] : ( ( A > $o ) > ( set @ A ) ) ).

thf(sy_c_Set_Oinsert,type,
    insert2: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Oremove,type,
    remove: 
      !>[A: $tType] : ( A > ( set @ A ) > ( set @ A ) ) ).

thf(sy_c_Set_Othe__elem,type,
    the_elem: 
      !>[A: $tType] : ( ( set @ A ) > A ) ).

thf(sy_c_Sum__Type_OInl,type,
    sum_Inl: 
      !>[A: $tType,B: $tType] : ( A > ( sum_sum @ A @ B ) ) ).

thf(sy_c_Sum__Type_OInr,type,
    sum_Inr: 
      !>[B: $tType,A: $tType] : ( B > ( sum_sum @ A @ B ) ) ).

thf(sy_c_Sum__Type_Oold_Osum_Orec__sum,type,
    sum_rec_sum: 
      !>[A: $tType,T: $tType,B: $tType] : ( ( A > T ) > ( B > T ) > ( sum_sum @ A @ B ) > T ) ).

thf(sy_c_member,type,
    member: 
      !>[A: $tType] : ( A > ( set @ A ) > $o ) ).

thf(sy_v_f,type,
    f: n > dtree ).

thf(sy_v_nl____,type,
    nl: list @ n ).

thf(sy_v_ns,type,
    ns: set @ n ).

thf(sy_v_nsa____,type,
    nsa: set @ n ).

thf(sy_v_tr,type,
    tr: dtree ).

thf(sy_v_tr1,type,
    tr1: dtree ).

thf(sy_v_tr1a____,type,
    tr1a: dtree ).

thf(sy_v_tr2____,type,
    tr2: dtree ).

thf(sy_v_tra____,type,
    tra: dtree ).

%----Relevant facts (255)
thf(fact_0_reg__root,axiom,
    ! [F: n > dtree,Tr: dtree] :
      ( ( gram_L1918716148le_reg @ F @ Tr )
     => ( ( F @ ( root @ Tr ) )
        = Tr ) ) ).

% reg_root
thf(fact_1_tr,axiom,
    gram_L1918716148le_reg @ f @ tra ).

% tr
thf(fact_2_tr1__tr,axiom,
    member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ tr1a ) @ ( cont @ tra ) ).

% tr1_tr
thf(fact_3_nl,axiom,
    gram_L250615845e_path @ f @ nl ).

% nl
thf(fact_4_f,axiom,
    gram_L1918716148le_reg @ f @ tr ).

% f
thf(fact_5_f__nl,axiom,
    ( ( f @ ( hd @ n @ nl ) )
    = tr1a ) ).

% f_nl
thf(fact_6_rtr,axiom,
    member @ n @ ( root @ tra ) @ nsa ).

% rtr
thf(fact_7_tr1,axiom,
    gram_L1918716148le_reg @ f @ tr1a ).

% tr1
thf(fact_8_path__NE,axiom,
    ! [F: n > dtree,Nl: list @ n] :
      ( ( gram_L250615845e_path @ F @ Nl )
     => ( Nl
       != ( nil @ n ) ) ) ).

% path_NE
thf(fact_9_path_OInd,axiom,
    ! [F: n > dtree,N1: n,Nl: list @ n,N: n] :
      ( ( gram_L250615845e_path @ F @ ( cons @ n @ N1 @ Nl ) )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ ( F @ N1 ) ) @ ( cont @ ( F @ N ) ) )
       => ( gram_L250615845e_path @ F @ ( cons @ n @ N @ ( cons @ n @ N1 @ Nl ) ) ) ) ) ).

% path.Ind
thf(fact_10_path_OBase,axiom,
    ! [F: n > dtree,N: n] : ( gram_L250615845e_path @ F @ ( cons @ n @ N @ ( nil @ n ) ) ) ).

% path.Base
thf(fact_11_path__post,axiom,
    ! [F: n > dtree,N: n,Nl: list @ n] :
      ( ( gram_L250615845e_path @ F @ ( cons @ n @ N @ Nl ) )
     => ( ( Nl
         != ( nil @ n ) )
       => ( gram_L250615845e_path @ F @ Nl ) ) ) ).

% path_post
thf(fact_12_path_Ocases,axiom,
    ! [F: n > dtree,A2: list @ n] :
      ( ( gram_L250615845e_path @ F @ A2 )
     => ( ! [N2: n] :
            ( A2
           != ( cons @ n @ N2 @ ( nil @ n ) ) )
       => ~ ! [N12: n,Nl2: list @ n,N2: n] :
              ( ( A2
                = ( cons @ n @ N2 @ ( cons @ n @ N12 @ Nl2 ) ) )
             => ( ( gram_L250615845e_path @ F @ ( cons @ n @ N12 @ Nl2 ) )
               => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ ( F @ N12 ) ) @ ( cont @ ( F @ N2 ) ) ) ) ) ) ) ).

% path.cases
thf(fact_13_path_Osimps,axiom,
    ( gram_L250615845e_path
    = ( ^ [F2: n > dtree,A3: list @ n] :
          ( ? [N3: n] :
              ( A3
              = ( cons @ n @ N3 @ ( nil @ n ) ) )
          | ? [N13: n,Nl3: list @ n,N3: n] :
              ( ( A3
                = ( cons @ n @ N3 @ ( cons @ n @ N13 @ Nl3 ) ) )
              & ( gram_L250615845e_path @ F2 @ ( cons @ n @ N13 @ Nl3 ) )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ ( F2 @ N13 ) ) @ ( cont @ ( F2 @ N3 ) ) ) ) ) ) ) ).

% path.simps
thf(fact_14_path_Oinducts,axiom,
    ! [F: n > dtree,X: list @ n,P: ( list @ n ) > $o] :
      ( ( gram_L250615845e_path @ F @ X )
     => ( ! [N2: n] : ( P @ ( cons @ n @ N2 @ ( nil @ n ) ) )
       => ( ! [N12: n,Nl2: list @ n,N2: n] :
              ( ( gram_L250615845e_path @ F @ ( cons @ n @ N12 @ Nl2 ) )
             => ( ( P @ ( cons @ n @ N12 @ Nl2 ) )
               => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ ( F @ N12 ) ) @ ( cont @ ( F @ N2 ) ) )
                 => ( P @ ( cons @ n @ N2 @ ( cons @ n @ N12 @ Nl2 ) ) ) ) ) )
         => ( P @ X ) ) ) ) ).

% path.inducts
thf(fact_15_last__nl,axiom,
    ( ( f @ ( last @ n @ nl ) )
    = tr2 ) ).

% last_nl
thf(fact_16_reg__Inr__cont,axiom,
    ! [F: n > dtree,Tr: dtree,Tr2: dtree] :
      ( ( gram_L1918716148le_reg @ F @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr2 ) @ ( cont @ Tr ) )
       => ( gram_L1918716148le_reg @ F @ Tr2 ) ) ) ).

% reg_Inr_cont
thf(fact_17_sum_Oinject_I2_J,axiom,
    ! [A: $tType,B: $tType,X2: B,Y2: B] :
      ( ( ( sum_Inr @ B @ A @ X2 )
        = ( sum_Inr @ B @ A @ Y2 ) )
      = ( X2 = Y2 ) ) ).

% sum.inject(2)
thf(fact_18_old_Osum_Oinject_I2_J,axiom,
    ! [A: $tType,B: $tType,B2: B,B3: B] :
      ( ( ( sum_Inr @ B @ A @ B2 )
        = ( sum_Inr @ B @ A @ B3 ) )
      = ( B2 = B3 ) ) ).

% old.sum.inject(2)
thf(fact_19_list_Oinject,axiom,
    ! [A: $tType,X21: A,X22: list @ A,Y21: A,Y22: list @ A] :
      ( ( ( cons @ A @ X21 @ X22 )
        = ( cons @ A @ Y21 @ Y22 ) )
      = ( ( X21 = Y21 )
        & ( X22 = Y22 ) ) ) ).

% list.inject
thf(fact_20_dtree__cong,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( ( root @ Tr )
        = ( root @ Tr2 ) )
     => ( ( ( cont @ Tr )
          = ( cont @ Tr2 ) )
       => ( Tr = Tr2 ) ) ) ).

% dtree_cong
thf(fact_21_hsubst__c__def,axiom,
    ( gram_L1905609002ubst_c
    = ( ^ [Tr0: dtree,Tr3: dtree] :
          ( if @ ( set @ ( sum_sum @ t @ dtree ) )
          @ ( ( root @ Tr3 )
            = ( root @ Tr0 ) )
          @ ( cont @ Tr0 )
          @ ( cont @ Tr3 ) ) ) ) ).

% hsubst_c_def
thf(fact_22_list_Odistinct_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( nil @ A )
     != ( cons @ A @ X21 @ X22 ) ) ).

% list.distinct(1)
thf(fact_23_list_OdiscI,axiom,
    ! [A: $tType,List: list @ A,X21: A,X22: list @ A] :
      ( ( List
        = ( cons @ A @ X21 @ X22 ) )
     => ( List
       != ( nil @ A ) ) ) ).

% list.discI
thf(fact_24_list_Oexhaust,axiom,
    ! [A: $tType,Y: list @ A] :
      ( ( Y
       != ( nil @ A ) )
     => ~ ! [X212: A,X222: list @ A] :
            ( Y
           != ( cons @ A @ X212 @ X222 ) ) ) ).

% list.exhaust
thf(fact_25_list_Oinducts,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,List: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X1: A,X23: list @ A] :
            ( ( P @ X23 )
           => ( P @ ( cons @ A @ X1 @ X23 ) ) )
       => ( P @ List ) ) ) ).

% list.inducts
thf(fact_26_neq__Nil__conv,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
      = ( ? [Y3: A,Ys: list @ A] :
            ( Xs
            = ( cons @ A @ Y3 @ Ys ) ) ) ) ).

% neq_Nil_conv
thf(fact_27_tr2__tr1,axiom,
    gram_L716654942_subtr @ nsa @ tr2 @ tr1a ).

% tr2_tr1
thf(fact_28_last__ConsR,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ( last @ A @ ( cons @ A @ X @ Xs ) )
        = ( last @ A @ Xs ) ) ) ).

% last_ConsR
thf(fact_29_last__ConsL,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( Xs
        = ( nil @ A ) )
     => ( ( last @ A @ ( cons @ A @ X @ Xs ) )
        = X ) ) ).

% last_ConsL
thf(fact_30_last_Osimps,axiom,
    ! [A: $tType,Xs: list @ A,X: A] :
      ( ( ( Xs
          = ( nil @ A ) )
       => ( ( last @ A @ ( cons @ A @ X @ Xs ) )
          = X ) )
      & ( ( Xs
         != ( nil @ A ) )
       => ( ( last @ A @ ( cons @ A @ X @ Xs ) )
          = ( last @ A @ Xs ) ) ) ) ).

% last.simps
thf(fact_31_list_Osel_I1_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( hd @ A @ ( cons @ A @ X21 @ X22 ) )
      = X21 ) ).

% list.sel(1)
thf(fact_32_not__Cons__self2,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( cons @ A @ X @ Xs )
     != Xs ) ).

% not_Cons_self2
thf(fact_33_Inr__inject,axiom,
    ! [A: $tType,B: $tType,X: B,Y: B] :
      ( ( ( sum_Inr @ B @ A @ X )
        = ( sum_Inr @ B @ A @ Y ) )
     => ( X = Y ) ) ).

% Inr_inject
thf(fact_34_map__tailrec__rev_Oinduct,axiom,
    ! [A: $tType,B: $tType,P: ( A > B ) > ( list @ A ) > ( list @ B ) > $o,A0: A > B,A1: list @ A,A22: list @ B] :
      ( ! [F3: A > B,X1: list @ B] : ( P @ F3 @ ( nil @ A ) @ X1 )
     => ( ! [F3: A > B,A4: A,As: list @ A,Bs: list @ B] :
            ( ( P @ F3 @ As @ ( cons @ B @ ( F3 @ A4 ) @ Bs ) )
           => ( P @ F3 @ ( cons @ A @ A4 @ As ) @ Bs ) )
       => ( P @ A0 @ A1 @ A22 ) ) ) ).

% map_tailrec_rev.induct
thf(fact_35_list__nonempty__induct,axiom,
    ! [A: $tType,Xs: list @ A,P: ( list @ A ) > $o] :
      ( ( Xs
       != ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Xs2: list @ A] :
              ( ( Xs2
               != ( nil @ A ) )
             => ( ( P @ Xs2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) ) )
         => ( P @ Xs ) ) ) ) ).

% list_nonempty_induct
thf(fact_36_remdups__adj_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > $o,A0: list @ A] :
      ( ( P @ ( nil @ A ) )
     => ( ! [X3: A] : ( P @ ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ( ! [X3: A,Y4: A,Xs2: list @ A] :
              ( ( ( X3 = Y4 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) ) )
             => ( ( ( X3 != Y4 )
                 => ( P @ ( cons @ A @ Y4 @ Xs2 ) ) )
               => ( P @ ( cons @ A @ X3 @ ( cons @ A @ Y4 @ Xs2 ) ) ) ) )
         => ( P @ A0 ) ) ) ) ).

% remdups_adj.induct
thf(fact_37_remdups__adj_Ocases,axiom,
    ! [A: $tType,X: list @ A] :
      ( ( X
       != ( nil @ A ) )
     => ( ! [X3: A] :
            ( X
           != ( cons @ A @ X3 @ ( nil @ A ) ) )
       => ~ ! [X3: A,Y4: A,Xs2: list @ A] :
              ( X
             != ( cons @ A @ X3 @ ( cons @ A @ Y4 @ Xs2 ) ) ) ) ) ).

% remdups_adj.cases
thf(fact_38_transpose_Ocases,axiom,
    ! [A: $tType,X: list @ ( list @ A )] :
      ( ( X
       != ( nil @ ( list @ A ) ) )
     => ( ! [Xss: list @ ( list @ A )] :
            ( X
           != ( cons @ ( list @ A ) @ ( nil @ A ) @ Xss ) )
       => ~ ! [X3: A,Xs2: list @ A,Xss: list @ ( list @ A )] :
              ( X
             != ( cons @ ( list @ A ) @ ( cons @ A @ X3 @ Xs2 ) @ Xss ) ) ) ) ).

% transpose.cases
thf(fact_39_splice_Oinduct,axiom,
    ! [A: $tType,P: ( list @ A ) > ( list @ A ) > $o,A0: list @ A,A1: list @ A] :
      ( ! [X1: list @ A] : ( P @ ( nil @ A ) @ X1 )
     => ( ! [V: A,Va: list @ A] : ( P @ ( cons @ A @ V @ Va ) @ ( nil @ A ) )
       => ( ! [X3: A,Xs2: list @ A,Y4: A,Ys2: list @ A] :
              ( ( P @ Xs2 @ Ys2 )
             => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ A @ Y4 @ Ys2 ) ) )
         => ( P @ A0 @ A1 ) ) ) ) ).

% splice.induct
thf(fact_40_list__induct2_H,axiom,
    ! [A: $tType,B: $tType,P: ( list @ A ) > ( list @ B ) > $o,Xs: list @ A,Ys3: list @ B] :
      ( ( P @ ( nil @ A ) @ ( nil @ B ) )
     => ( ! [X3: A,Xs2: list @ A] : ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( nil @ B ) )
       => ( ! [Y4: B,Ys2: list @ B] : ( P @ ( nil @ A ) @ ( cons @ B @ Y4 @ Ys2 ) )
         => ( ! [X3: A,Xs2: list @ A,Y4: B,Ys2: list @ B] :
                ( ( P @ Xs2 @ Ys2 )
               => ( P @ ( cons @ A @ X3 @ Xs2 ) @ ( cons @ B @ Y4 @ Ys2 ) ) )
           => ( P @ Xs @ Ys3 ) ) ) ) ) ).

% list_induct2'
thf(fact_41_n,axiom,
    gram_L716654942_subtr @ ns @ tr1 @ tr ).

% n
thf(fact_42__092_060open_062_092_060And_062thesis_O_A_I_092_060And_062nl_O_A_092_060lbrakk_062path_Af_Anl_059_Af_A_Ihd_Anl_J_A_061_Atr1_059_Af_A_Ilast_Anl_J_A_061_Atr2_059_Aset_Anl_A_092_060subseteq_062_Ans_092_060rbrakk_062_A_092_060Longrightarrow_062_Athesis_J_A_092_060Longrightarrow_062_Athesis_092_060close_062,axiom,
    ~ ! [Nl2: list @ n] :
        ( ( gram_L250615845e_path @ f @ Nl2 )
       => ( ( ( f @ ( hd @ n @ Nl2 ) )
            = tr1a )
         => ( ( ( f @ ( last @ n @ Nl2 ) )
              = tr2 )
           => ~ ( ord_less_eq @ ( set @ n ) @ ( set2 @ n @ Nl2 ) @ nsa ) ) ) ) ).

% \<open>\<And>thesis. (\<And>nl. \<lbrakk>path f nl; f (hd nl) = tr1; f (last nl) = tr2; set nl \<subseteq> ns\<rbrakk> \<Longrightarrow> thesis) \<Longrightarrow> thesis\<close>
thf(fact_43_old_Osum_Osimps_I8_J,axiom,
    ! [A: $tType,T: $tType,B: $tType,F1: A > T,F22: B > T,B2: B] :
      ( ( sum_rec_sum @ A @ T @ B @ F1 @ F22 @ ( sum_Inr @ B @ A @ B2 ) )
      = ( F22 @ B2 ) ) ).

% old.sum.simps(8)
thf(fact_44_mem__Collect__eq,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( member @ A @ A2 @ ( collect @ A @ P ) )
      = ( P @ A2 ) ) ).

% mem_Collect_eq
thf(fact_45_Collect__mem__eq,axiom,
    ! [A: $tType,A5: set @ A] :
      ( ( collect @ A
        @ ^ [X4: A] : ( member @ A @ X4 @ A5 ) )
      = A5 ) ).

% Collect_mem_eq
thf(fact_46_Collect__cong,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
          = ( Q @ X3 ) )
     => ( ( collect @ A @ P )
        = ( collect @ A @ Q ) ) ) ).

% Collect_cong
thf(fact_47_ext,axiom,
    ! [B: $tType,A: $tType,F: A > B,G: A > B] :
      ( ! [X3: A] :
          ( ( F @ X3 )
          = ( G @ X3 ) )
     => ( F = G ) ) ).

% ext
thf(fact_48_Node__root__cont,axiom,
    ! [Tr: dtree] :
      ( ( node @ ( root @ Tr ) @ ( cont @ Tr ) )
      = Tr ) ).

% Node_root_cont
thf(fact_49_regular__def2,axiom,
    ( gram_L646766332egular
    = ( ^ [Tr3: dtree] :
        ? [F2: n > dtree] :
          ( ( gram_L1918716148le_reg @ F2 @ Tr3 )
          & ! [N3: n] :
              ( ( root @ ( F2 @ N3 ) )
              = N3 ) ) ) ) ).

% regular_def2
thf(fact_50_set,axiom,
    ord_less_eq @ ( set @ n ) @ ( set2 @ n @ nl ) @ nsa ).

% set
thf(fact_51_Step_Oprems,axiom,
    gram_L1918716148le_reg @ f @ tra ).

% Step.prems
thf(fact_52_wf__inj,axiom,
    ! [Tr: dtree,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr ) )
         => ( ( ( root @ Tr1 )
              = ( root @ Tr22 ) )
            = ( Tr1 = Tr22 ) ) ) ) ) ).

% wf_inj
thf(fact_53_inFr2__Ind,axiom,
    ! [Ns: set @ n,Tr1: dtree,T2: t,Tr: dtree] :
      ( ( gram_L805317441_inFr2 @ Ns @ Tr1 @ T2 )
     => ( ( member @ n @ ( root @ Tr ) @ Ns )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
         => ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 ) ) ) ) ).

% inFr2_Ind
thf(fact_54_Step_Ohyps_I3_J,axiom,
    ( ( gram_L1918716148le_reg @ f @ tr1a )
   => ? [Nl2: list @ n] :
        ( ( gram_L250615845e_path @ f @ Nl2 )
        & ( ( f @ ( hd @ n @ Nl2 ) )
          = tr1a )
        & ( ( f @ ( last @ n @ Nl2 ) )
          = tr2 )
        & ( ord_less_eq @ ( set @ n ) @ ( set2 @ n @ Nl2 ) @ nsa ) ) ) ).

% Step.hyps(3)
thf(fact_55_root__Node,axiom,
    ! [N: n,As2: set @ ( sum_sum @ t @ dtree )] :
      ( ( root @ ( node @ N @ As2 ) )
      = N ) ).

% root_Node
thf(fact_56_subset__code_I1_J,axiom,
    ! [A: $tType,Xs: list @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ B4 )
      = ( ! [X4: A] :
            ( ( member @ A @ X4 @ ( set2 @ A @ Xs ) )
           => ( member @ A @ X4 @ B4 ) ) ) ) ).

% subset_code(1)
thf(fact_57_set__subset__Cons,axiom,
    ! [A: $tType,Xs: list @ A,X: A] : ( ord_less_eq @ ( set @ A ) @ ( set2 @ A @ Xs ) @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) ) ).

% set_subset_Cons
thf(fact_58_regular__subtr,axiom,
    ! [Tr: dtree,Ns: set @ n,Tr2: dtree] :
      ( ( gram_L646766332egular @ Tr )
     => ( ( gram_L716654942_subtr @ Ns @ Tr2 @ Tr )
       => ( gram_L646766332egular @ Tr2 ) ) ) ).

% regular_subtr
thf(fact_59_subtr__trans,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Tr32: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr22 @ Tr32 )
       => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr32 ) ) ) ).

% subtr_trans
thf(fact_60_subtr__mono,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Ns2: set @ n] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( ( ord_less_eq @ ( set @ n ) @ Ns @ Ns2 )
       => ( gram_L716654942_subtr @ Ns2 @ Tr1 @ Tr22 ) ) ) ).

% subtr_mono
thf(fact_61_inFr2__mono,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t,Ns2: set @ n] :
      ( ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 )
     => ( ( ord_less_eq @ ( set @ n ) @ Ns @ Ns2 )
       => ( gram_L805317441_inFr2 @ Ns2 @ Tr @ T2 ) ) ) ).

% inFr2_mono
thf(fact_62_wf__subtr,axiom,
    ! [Tr1: dtree,Ns: set @ n,Tr: dtree] :
      ( ( gram_L864798063lle_wf @ Tr1 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr @ Tr1 )
       => ( gram_L864798063lle_wf @ Tr ) ) ) ).

% wf_subtr
thf(fact_63_list_Oset__intros_I2_J,axiom,
    ! [A: $tType,X: A,A22: list @ A,A1: A] :
      ( ( member @ A @ X @ ( set2 @ A @ A22 ) )
     => ( member @ A @ X @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ) ).

% list.set_intros(2)
thf(fact_64_list_Oset__intros_I1_J,axiom,
    ! [A: $tType,A1: A,A22: list @ A] : ( member @ A @ A1 @ ( set2 @ A @ ( cons @ A @ A1 @ A22 ) ) ) ).

% list.set_intros(1)
thf(fact_65_set__ConsD,axiom,
    ! [A: $tType,Y: A,X: A,Xs: list @ A] :
      ( ( member @ A @ Y @ ( set2 @ A @ ( cons @ A @ X @ Xs ) ) )
     => ( ( Y = X )
        | ( member @ A @ Y @ ( set2 @ A @ Xs ) ) ) ) ).

% set_ConsD
thf(fact_66_list_Oset__cases,axiom,
    ! [A: $tType,E: A,A2: list @ A] :
      ( ( member @ A @ E @ ( set2 @ A @ A2 ) )
     => ( ! [Z2: list @ A] :
            ( A2
           != ( cons @ A @ E @ Z2 ) )
       => ~ ! [Z1: A,Z2: list @ A] :
              ( ( A2
                = ( cons @ A @ Z1 @ Z2 ) )
             => ~ ( member @ A @ E @ ( set2 @ A @ Z2 ) ) ) ) ) ).

% list.set_cases
thf(fact_67_subtr_ORefl,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L716654942_subtr @ Ns @ Tr @ Tr ) ) ).

% subtr.Refl
thf(fact_68_subtr__rootL__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr1 ) @ Ns ) ) ).

% subtr_rootL_in
thf(fact_69_subtr__rootR__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr22 ) @ Ns ) ) ).

% subtr_rootR_in
thf(fact_70_reg__subtr,axiom,
    ! [F: n > dtree,Tr: dtree,Ns: set @ n,Tr2: dtree] :
      ( ( gram_L1918716148le_reg @ F @ Tr )
     => ( ( gram_L716654942_subtr @ Ns @ Tr2 @ Tr )
       => ( gram_L1918716148le_reg @ F @ Tr2 ) ) ) ).

% reg_subtr
thf(fact_71_inFr2__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inFr2_root_in
thf(fact_72_list_Oset__sel_I1_J,axiom,
    ! [A: $tType,A2: list @ A] :
      ( ( A2
       != ( nil @ A ) )
     => ( member @ A @ ( hd @ A @ A2 ) @ ( set2 @ A @ A2 ) ) ) ).

% list.set_sel(1)
thf(fact_73_hd__in__set,axiom,
    ! [A: $tType,Xs: list @ A] :
      ( ( Xs
       != ( nil @ A ) )
     => ( member @ A @ ( hd @ A @ Xs ) @ ( set2 @ A @ Xs ) ) ) ).

% hd_in_set
thf(fact_74_last__in__set,axiom,
    ! [A: $tType,As2: list @ A] :
      ( ( As2
       != ( nil @ A ) )
     => ( member @ A @ ( last @ A @ As2 ) @ ( set2 @ A @ As2 ) ) ) ).

% last_in_set
thf(fact_75_path__subtr,axiom,
    ! [F: n > dtree,Nl: list @ n] :
      ( ! [N2: n] :
          ( ( root @ ( F @ N2 ) )
          = N2 )
     => ( ( gram_L250615845e_path @ F @ Nl )
       => ( gram_L716654942_subtr @ ( set2 @ n @ Nl ) @ ( F @ ( last @ n @ Nl ) ) @ ( F @ ( hd @ n @ Nl ) ) ) ) ) ).

% path_subtr
thf(fact_76_reg__def2,axiom,
    ( gram_L1918716148le_reg
    = ( ^ [F2: n > dtree,Tr3: dtree] :
        ! [Ns3: set @ n,Tr4: dtree] :
          ( ( gram_L716654942_subtr @ Ns3 @ Tr4 @ Tr3 )
         => ( Tr4
            = ( F2 @ ( root @ Tr4 ) ) ) ) ) ) ).

% reg_def2
thf(fact_77_wf__cont,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr2 ) @ ( cont @ Tr ) )
       => ( gram_L864798063lle_wf @ Tr2 ) ) ) ).

% wf_cont
thf(fact_78_subtr_OStep,axiom,
    ! [Tr32: dtree,Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( member @ n @ ( root @ Tr32 ) @ Ns )
     => ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
       => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr32 ) )
         => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr32 ) ) ) ) ).

% subtr.Step
thf(fact_79_subtr_Ocases,axiom,
    ! [A1: set @ n,A22: dtree,A32: dtree] :
      ( ( gram_L716654942_subtr @ A1 @ A22 @ A32 )
     => ( ( ( A32 = A22 )
         => ~ ( member @ n @ ( root @ A22 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A32 ) @ A1 )
           => ! [Tr23: dtree] :
                ( ( gram_L716654942_subtr @ A1 @ A22 @ Tr23 )
               => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr23 ) @ ( cont @ A32 ) ) ) ) ) ) ).

% subtr.cases
thf(fact_80_subtr_Osimps,axiom,
    ( gram_L716654942_subtr
    = ( ^ [A12: set @ n,A23: dtree,A33: dtree] :
          ( ? [Tr3: dtree,Ns3: set @ n] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr3 )
              & ( A33 = Tr3 )
              & ( member @ n @ ( root @ Tr3 ) @ Ns3 ) )
          | ? [Tr33: dtree,Ns3: set @ n,Tr12: dtree,Tr24: dtree] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr12 )
              & ( A33 = Tr33 )
              & ( member @ n @ ( root @ Tr33 ) @ Ns3 )
              & ( gram_L716654942_subtr @ Ns3 @ Tr12 @ Tr24 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr24 ) @ ( cont @ Tr33 ) ) ) ) ) ) ).

% subtr.simps
thf(fact_81_subtr__StepL,axiom,
    ! [Tr1: dtree,Ns: set @ n,Tr22: dtree,Tr32: dtree] :
      ( ( member @ n @ ( root @ Tr1 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr22 ) )
       => ( ( gram_L716654942_subtr @ Ns @ Tr22 @ Tr32 )
         => ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr32 ) ) ) ) ).

% subtr_StepL
thf(fact_82_subtr_Oinducts,axiom,
    ! [X12: set @ n,X2: dtree,X32: dtree,P: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L716654942_subtr @ X12 @ X2 @ X32 )
     => ( ! [Tr5: dtree,Ns4: set @ n] :
            ( ( member @ n @ ( root @ Tr5 ) @ Ns4 )
           => ( P @ Ns4 @ Tr5 @ Tr5 ) )
       => ( ! [Tr34: dtree,Ns4: set @ n,Tr13: dtree,Tr23: dtree] :
              ( ( member @ n @ ( root @ Tr34 ) @ Ns4 )
             => ( ( gram_L716654942_subtr @ Ns4 @ Tr13 @ Tr23 )
               => ( ( P @ Ns4 @ Tr13 @ Tr23 )
                 => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr23 ) @ ( cont @ Tr34 ) )
                   => ( P @ Ns4 @ Tr13 @ Tr34 ) ) ) ) )
         => ( P @ X12 @ X2 @ X32 ) ) ) ) ).

% subtr.inducts
thf(fact_83_subtr__inductL,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Phi: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L716654942_subtr @ Ns @ Tr1 @ Tr22 )
     => ( ! [Ns4: set @ n,Tr5: dtree] : ( Phi @ Ns4 @ Tr5 @ Tr5 )
       => ( ! [Ns4: set @ n,Tr13: dtree,Tr23: dtree,Tr34: dtree] :
              ( ( member @ n @ ( root @ Tr13 ) @ Ns4 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr23 ) )
               => ( ( gram_L716654942_subtr @ Ns4 @ Tr23 @ Tr34 )
                 => ( ( Phi @ Ns4 @ Tr23 @ Tr34 )
                   => ( Phi @ Ns4 @ Tr13 @ Tr34 ) ) ) ) )
         => ( Phi @ Ns @ Tr1 @ Tr22 ) ) ) ) ).

% subtr_inductL
thf(fact_84_regular__def,axiom,
    ( gram_L646766332egular
    = ( ^ [Tr3: dtree] :
        ? [F2: n > dtree] : ( gram_L1918716148le_reg @ F2 @ Tr3 ) ) ) ).

% regular_def
thf(fact_85_subtrOf__root,axiom,
    ! [Tr: dtree,Tr2: dtree] :
      ( ( gram_L864798063lle_wf @ Tr )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr2 ) @ ( cont @ Tr ) )
       => ( ( gram_L1614515765ubtrOf @ Tr @ ( root @ Tr2 ) )
          = Tr2 ) ) ) ).

% subtrOf_root
thf(fact_86_subset__antisym,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B4 @ A5 )
       => ( A5 = B4 ) ) ) ).

% subset_antisym
thf(fact_87_subsetI,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ! [X3: A] :
          ( ( member @ A @ X3 @ A5 )
         => ( member @ A @ X3 @ B4 ) )
     => ( ord_less_eq @ ( set @ A ) @ A5 @ B4 ) ) ).

% subsetI
thf(fact_88_order__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A] : ( ord_less_eq @ A @ X @ X ) ) ).

% order_refl
thf(fact_89_sublists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( sublists @ A @ ( nil @ A ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% sublists.simps(1)
thf(fact_90_path__distinct,axiom,
    ! [F: n > dtree,Nl: list @ n] :
      ( ( gram_L250615845e_path @ F @ Nl )
     => ? [Nl4: list @ n] :
          ( ( gram_L250615845e_path @ F @ Nl4 )
          & ( ( hd @ n @ Nl4 )
            = ( hd @ n @ Nl ) )
          & ( ( last @ n @ Nl4 )
            = ( last @ n @ Nl ) )
          & ( ord_less_eq @ ( set @ n ) @ ( set2 @ n @ Nl4 ) @ ( set2 @ n @ Nl ) )
          & ( distinct @ n @ Nl4 ) ) ) ).

% path_distinct
thf(fact_91_product__lists_Osimps_I1_J,axiom,
    ! [A: $tType] :
      ( ( product_lists @ A @ ( nil @ ( list @ A ) ) )
      = ( cons @ ( list @ A ) @ ( nil @ A ) @ ( nil @ ( list @ A ) ) ) ) ).

% product_lists.simps(1)
thf(fact_92_the__elem__set,axiom,
    ! [A: $tType,X: A] :
      ( ( the_elem @ A @ ( set2 @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) )
      = X ) ).

% the_elem_set
thf(fact_93_distinct__product__lists,axiom,
    ! [A: $tType,Xss2: list @ ( list @ A )] :
      ( ! [X3: list @ A] :
          ( ( member @ ( list @ A ) @ X3 @ ( set2 @ ( list @ A ) @ Xss2 ) )
         => ( distinct @ A @ X3 ) )
     => ( distinct @ ( list @ A ) @ ( product_lists @ A @ Xss2 ) ) ) ).

% distinct_product_lists
thf(fact_94_less__eq__set__def,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A6: set @ A,B5: set @ A] :
            ( ord_less_eq @ ( A > $o )
            @ ^ [X4: A] : ( member @ A @ X4 @ A6 )
            @ ^ [X4: A] : ( member @ A @ X4 @ B5 ) ) ) ) ).

% less_eq_set_def
thf(fact_95_distinct__length__2__or__more,axiom,
    ! [A: $tType,A2: A,B2: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ A2 @ ( cons @ A @ B2 @ Xs ) ) )
      = ( ( A2 != B2 )
        & ( distinct @ A @ ( cons @ A @ A2 @ Xs ) )
        & ( distinct @ A @ ( cons @ A @ B2 @ Xs ) ) ) ) ).

% distinct_length_2_or_more
thf(fact_96_distinct_Osimps_I1_J,axiom,
    ! [A: $tType] : ( distinct @ A @ ( nil @ A ) ) ).

% distinct.simps(1)
thf(fact_97_distinct__singleton,axiom,
    ! [A: $tType,X: A] : ( distinct @ A @ ( cons @ A @ X @ ( nil @ A ) ) ) ).

% distinct_singleton
thf(fact_98_distinct_Osimps_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( cons @ A @ X @ Xs ) )
      = ( ~ ( member @ A @ X @ ( set2 @ A @ Xs ) )
        & ( distinct @ A @ Xs ) ) ) ).

% distinct.simps(2)
thf(fact_99_le__funD,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funD
thf(fact_100_le__funE,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B,X: A] :
          ( ( ord_less_eq @ ( A > B ) @ F @ G )
         => ( ord_less_eq @ B @ ( F @ X ) @ ( G @ X ) ) ) ) ).

% le_funE
thf(fact_101_le__funI,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [F: A > B,G: A > B] :
          ( ! [X3: A] : ( ord_less_eq @ B @ ( F @ X3 ) @ ( G @ X3 ) )
         => ( ord_less_eq @ ( A > B ) @ F @ G ) ) ) ).

% le_funI
thf(fact_102_le__fun__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ( ( ord_less_eq @ ( A > B ) )
        = ( ^ [F2: A > B,G2: A > B] :
            ! [X4: A] : ( ord_less_eq @ B @ ( F2 @ X4 ) @ ( G2 @ X4 ) ) ) ) ) ).

% le_fun_def
thf(fact_103_order__subst1,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( order @ B @ ( type2 @ B ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( ord_less_eq @ A @ A2 @ ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C )
           => ( ! [X3: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X3 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X3 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% order_subst1
thf(fact_104_order__subst2,axiom,
    ! [A: $tType,C2: $tType] :
      ( ( ( order @ C2 @ ( type2 @ C2 ) )
        & ( order @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > C2,C: C2] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ C2 @ ( F @ B2 ) @ C )
           => ( ! [X3: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y4 )
                 => ( ord_less_eq @ C2 @ ( F @ X3 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ C2 @ ( F @ A2 ) @ C ) ) ) ) ) ).

% order_subst2
thf(fact_105_ord__eq__le__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,F: B > A,B2: B,C: B] :
          ( ( A2
            = ( F @ B2 ) )
         => ( ( ord_less_eq @ B @ B2 @ C )
           => ( ! [X3: B,Y4: B] :
                  ( ( ord_less_eq @ B @ X3 @ Y4 )
                 => ( ord_less_eq @ A @ ( F @ X3 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ A @ A2 @ ( F @ C ) ) ) ) ) ) ).

% ord_eq_le_subst
thf(fact_106_ord__le__eq__subst,axiom,
    ! [A: $tType,B: $tType] :
      ( ( ( ord @ B @ ( type2 @ B ) )
        & ( ord @ A @ ( type2 @ A ) ) )
     => ! [A2: A,B2: A,F: A > B,C: B] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ( F @ B2 )
              = C )
           => ( ! [X3: A,Y4: A] :
                  ( ( ord_less_eq @ A @ X3 @ Y4 )
                 => ( ord_less_eq @ B @ ( F @ X3 ) @ ( F @ Y4 ) ) )
             => ( ord_less_eq @ B @ ( F @ A2 ) @ C ) ) ) ) ) ).

% ord_le_eq_subst
thf(fact_107_eq__iff,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ( ( ^ [Y5: A,Z: A] : ( Y5 = Z ) )
        = ( ^ [X4: A,Y3: A] :
              ( ( ord_less_eq @ A @ X4 @ Y3 )
              & ( ord_less_eq @ A @ Y3 @ X4 ) ) ) ) ) ).

% eq_iff
thf(fact_108_antisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ X )
           => ( X = Y ) ) ) ) ).

% antisym
thf(fact_109_linear,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( ord_less_eq @ A @ X @ Y )
          | ( ord_less_eq @ A @ Y @ X ) ) ) ).

% linear
thf(fact_110_eq__refl,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ( X = Y )
         => ( ord_less_eq @ A @ X @ Y ) ) ) ).

% eq_refl
thf(fact_111_le__cases,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A] :
          ( ~ ( ord_less_eq @ A @ X @ Y )
         => ( ord_less_eq @ A @ Y @ X ) ) ) ).

% le_cases
thf(fact_112_order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% order.trans
thf(fact_113_le__cases3,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z3: A] :
          ( ( ( ord_less_eq @ A @ X @ Y )
           => ~ ( ord_less_eq @ A @ Y @ Z3 ) )
         => ( ( ( ord_less_eq @ A @ Y @ X )
             => ~ ( ord_less_eq @ A @ X @ Z3 ) )
           => ( ( ( ord_less_eq @ A @ X @ Z3 )
               => ~ ( ord_less_eq @ A @ Z3 @ Y ) )
             => ( ( ( ord_less_eq @ A @ Z3 @ Y )
                 => ~ ( ord_less_eq @ A @ Y @ X ) )
               => ( ( ( ord_less_eq @ A @ Y @ Z3 )
                   => ~ ( ord_less_eq @ A @ Z3 @ X ) )
                 => ~ ( ( ord_less_eq @ A @ Z3 @ X )
                     => ~ ( ord_less_eq @ A @ X @ Y ) ) ) ) ) ) ) ) ).

% le_cases3
thf(fact_114_antisym__conv,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [Y: A,X: A] :
          ( ( ord_less_eq @ A @ Y @ X )
         => ( ( ord_less_eq @ A @ X @ Y )
            = ( X = Y ) ) ) ) ).

% antisym_conv
thf(fact_115_ord__eq__le__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( A2 = B2 )
         => ( ( ord_less_eq @ A @ B2 @ C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_eq_le_trans
thf(fact_116_ord__le__eq__trans,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A,C: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( B2 = C )
           => ( ord_less_eq @ A @ A2 @ C ) ) ) ) ).

% ord_le_eq_trans
thf(fact_117_order__class_Oorder_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A,B2: A] :
          ( ( ord_less_eq @ A @ A2 @ B2 )
         => ( ( ord_less_eq @ A @ B2 @ A2 )
           => ( A2 = B2 ) ) ) ) ).

% order_class.order.antisym
thf(fact_118_order__trans,axiom,
    ! [A: $tType] :
      ( ( preorder @ A @ ( type2 @ A ) )
     => ! [X: A,Y: A,Z3: A] :
          ( ( ord_less_eq @ A @ X @ Y )
         => ( ( ord_less_eq @ A @ Y @ Z3 )
           => ( ord_less_eq @ A @ X @ Z3 ) ) ) ) ).

% order_trans
thf(fact_119_dual__order_Orefl,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [A2: A] : ( ord_less_eq @ A @ A2 @ A2 ) ) ).

% dual_order.refl
thf(fact_120_linorder__wlog,axiom,
    ! [A: $tType] :
      ( ( linorder @ A @ ( type2 @ A ) )
     => ! [P: A > A > $o,A2: A,B2: A] :
          ( ! [A4: A,B6: A] :
              ( ( ord_less_eq @ A @ A4 @ B6 )
             => ( P @ A4 @ B6 ) )
         => ( ! [A4: A,B6: A] :
                ( ( P @ B6 @ A4 )
               => ( P @ A4 @ B6 ) )
           => ( P @ A2 @ B2 ) ) ) ) ).

% linorder_wlog
thf(fact_121_dual__order_Otrans,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A,C: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ C @ B2 )
           => ( ord_less_eq @ A @ C @ A2 ) ) ) ) ).

% dual_order.trans
thf(fact_122_dual__order_Oantisym,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [B2: A,A2: A] :
          ( ( ord_less_eq @ A @ B2 @ A2 )
         => ( ( ord_less_eq @ A @ A2 @ B2 )
           => ( A2 = B2 ) ) ) ) ).

% dual_order.antisym
thf(fact_123_set__mp,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
     => ( ( member @ A @ X @ A5 )
       => ( member @ A @ X @ B4 ) ) ) ).

% set_mp
thf(fact_124_in__mono,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,X: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
     => ( ( member @ A @ X @ A5 )
       => ( member @ A @ X @ B4 ) ) ) ).

% in_mono
thf(fact_125_subsetD,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
     => ( ( member @ A @ C @ A5 )
       => ( member @ A @ C @ B4 ) ) ) ).

% subsetD
thf(fact_126_subsetCE,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
     => ( ( member @ A @ C @ A5 )
       => ( member @ A @ C @ B4 ) ) ) ).

% subsetCE
thf(fact_127_equalityE,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ( A5 = B4 )
     => ~ ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
         => ~ ( ord_less_eq @ ( set @ A ) @ B4 @ A5 ) ) ) ).

% equalityE
thf(fact_128_subset__eq,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A6: set @ A,B5: set @ A] :
          ! [X4: A] :
            ( ( member @ A @ X4 @ A6 )
           => ( member @ A @ X4 @ B5 ) ) ) ) ).

% subset_eq
thf(fact_129_equalityD1,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ( A5 = B4 )
     => ( ord_less_eq @ ( set @ A ) @ A5 @ B4 ) ) ).

% equalityD1
thf(fact_130_equalityD2,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A] :
      ( ( A5 = B4 )
     => ( ord_less_eq @ ( set @ A ) @ B4 @ A5 ) ) ).

% equalityD2
thf(fact_131_set__rev__mp,axiom,
    ! [A: $tType,X: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ X @ A5 )
     => ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
       => ( member @ A @ X @ B4 ) ) ) ).

% set_rev_mp
thf(fact_132_subset__iff,axiom,
    ! [A: $tType] :
      ( ( ord_less_eq @ ( set @ A ) )
      = ( ^ [A6: set @ A,B5: set @ A] :
          ! [T3: A] :
            ( ( member @ A @ T3 @ A6 )
           => ( member @ A @ T3 @ B5 ) ) ) ) ).

% subset_iff
thf(fact_133_rev__subsetD,axiom,
    ! [A: $tType,C: A,A5: set @ A,B4: set @ A] :
      ( ( member @ A @ C @ A5 )
     => ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
       => ( member @ A @ C @ B4 ) ) ) ).

% rev_subsetD
thf(fact_134_subset__refl,axiom,
    ! [A: $tType,A5: set @ A] : ( ord_less_eq @ ( set @ A ) @ A5 @ A5 ) ).

% subset_refl
thf(fact_135_Collect__mono,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
         => ( Q @ X3 ) )
     => ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) ) ) ).

% Collect_mono
thf(fact_136_subset__trans,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,C3: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
     => ( ( ord_less_eq @ ( set @ A ) @ B4 @ C3 )
       => ( ord_less_eq @ ( set @ A ) @ A5 @ C3 ) ) ) ).

% subset_trans
thf(fact_137_set__eq__subset,axiom,
    ! [A: $tType] :
      ( ( ^ [Y5: set @ A,Z: set @ A] : ( Y5 = Z ) )
      = ( ^ [A6: set @ A,B5: set @ A] :
            ( ( ord_less_eq @ ( set @ A ) @ A6 @ B5 )
            & ( ord_less_eq @ ( set @ A ) @ B5 @ A6 ) ) ) ) ).

% set_eq_subset
thf(fact_138_contra__subsetD,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,C: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
     => ( ~ ( member @ A @ C @ B4 )
       => ~ ( member @ A @ C @ A5 ) ) ) ).

% contra_subsetD
thf(fact_139_Collect__mono__iff,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ ( collect @ A @ P ) @ ( collect @ A @ Q ) )
      = ( ! [X4: A] :
            ( ( P @ X4 )
           => ( Q @ X4 ) ) ) ) ).

% Collect_mono_iff
thf(fact_140_distinct__union,axiom,
    ! [A: $tType,Xs: list @ A,Ys3: list @ A] :
      ( ( distinct @ A @ ( union @ A @ Xs @ Ys3 ) )
      = ( distinct @ A @ Ys3 ) ) ).

% distinct_union
thf(fact_141_subtrOf__def,axiom,
    ( gram_L1614515765ubtrOf
    = ( ^ [Tr3: dtree,N3: n] :
        @+[Tr4: dtree] :
          ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr4 ) @ ( cont @ Tr3 ) )
          & ( ( root @ Tr4 )
            = N3 ) ) ) ) ).

% subtrOf_def
thf(fact_142_hsubst__r__def,axiom,
    gram_L1905609017ubst_r = root ).

% hsubst_r_def
thf(fact_143_inItr_Oinducts,axiom,
    ! [X12: set @ n,X2: dtree,X32: n,P: ( set @ n ) > dtree > n > $o] :
      ( ( gram_L830233218_inItr @ X12 @ X2 @ X32 )
     => ( ! [Tr5: dtree,Ns4: set @ n] :
            ( ( member @ n @ ( root @ Tr5 ) @ Ns4 )
           => ( P @ Ns4 @ Tr5 @ ( root @ Tr5 ) ) )
       => ( ! [Tr5: dtree,Ns4: set @ n,Tr13: dtree,N2: n] :
              ( ( member @ n @ ( root @ Tr5 ) @ Ns4 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr5 ) )
               => ( ( gram_L830233218_inItr @ Ns4 @ Tr13 @ N2 )
                 => ( ( P @ Ns4 @ Tr13 @ N2 )
                   => ( P @ Ns4 @ Tr5 @ N2 ) ) ) ) )
         => ( P @ X12 @ X2 @ X32 ) ) ) ) ).

% inItr.inducts
thf(fact_144_inItr_Osimps,axiom,
    ( gram_L830233218_inItr
    = ( ^ [A12: set @ n,A23: dtree,A33: n] :
          ( ? [Tr3: dtree,Ns3: set @ n] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr3 )
              & ( A33
                = ( root @ Tr3 ) )
              & ( member @ n @ ( root @ Tr3 ) @ Ns3 ) )
          | ? [Tr3: dtree,Ns3: set @ n,Tr12: dtree,N3: n] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr3 )
              & ( A33 = N3 )
              & ( member @ n @ ( root @ Tr3 ) @ Ns3 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr3 ) )
              & ( gram_L830233218_inItr @ Ns3 @ Tr12 @ N3 ) ) ) ) ) ).

% inItr.simps
thf(fact_145_predicate1I,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ! [X3: A] :
          ( ( P @ X3 )
         => ( Q @ X3 ) )
     => ( ord_less_eq @ ( A > $o ) @ P @ Q ) ) ).

% predicate1I
thf(fact_146_rev__predicate1D,axiom,
    ! [A: $tType,P: A > $o,X: A,Q: A > $o] :
      ( ( P @ X )
     => ( ( ord_less_eq @ ( A > $o ) @ P @ Q )
       => ( Q @ X ) ) ) ).

% rev_predicate1D
thf(fact_147_predicate1D,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o,X: A] :
      ( ( ord_less_eq @ ( A > $o ) @ P @ Q )
     => ( ( P @ X )
       => ( Q @ X ) ) ) ).

% predicate1D
thf(fact_148_inItr_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L830233218_inItr @ Ns @ Tr @ ( root @ Tr ) ) ) ).

% inItr.Base
thf(fact_149_inItr__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,N: n] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inItr_root_in
thf(fact_150_subtr__inItr,axiom,
    ! [Ns: set @ n,Tr: dtree,N: n,Tr1: dtree] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N )
     => ( ( gram_L716654942_subtr @ Ns @ Tr @ Tr1 )
       => ( gram_L830233218_inItr @ Ns @ Tr1 @ N ) ) ) ).

% subtr_inItr
thf(fact_151_inItr__mono,axiom,
    ! [Ns: set @ n,Tr: dtree,N: n,Ns2: set @ n] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N )
     => ( ( ord_less_eq @ ( set @ n ) @ Ns @ Ns2 )
       => ( gram_L830233218_inItr @ Ns2 @ Tr @ N ) ) ) ).

% inItr_mono
thf(fact_152_inItr__subtr,axiom,
    ! [Ns: set @ n,Tr: dtree,N: n] :
      ( ( gram_L830233218_inItr @ Ns @ Tr @ N )
     => ? [Tr6: dtree] :
          ( ( gram_L716654942_subtr @ Ns @ Tr6 @ Tr )
          & ( ( root @ Tr6 )
            = N ) ) ) ).

% inItr_subtr
thf(fact_153_inItr_OInd,axiom,
    ! [Tr: dtree,Ns: set @ n,Tr1: dtree,N: n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( gram_L830233218_inItr @ Ns @ Tr1 @ N )
         => ( gram_L830233218_inItr @ Ns @ Tr @ N ) ) ) ) ).

% inItr.Ind
thf(fact_154_inItr_Ocases,axiom,
    ! [A1: set @ n,A22: dtree,A32: n] :
      ( ( gram_L830233218_inItr @ A1 @ A22 @ A32 )
     => ( ( ( A32
            = ( root @ A22 ) )
         => ~ ( member @ n @ ( root @ A22 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A22 ) @ A1 )
           => ! [Tr13: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ A22 ) )
               => ~ ( gram_L830233218_inItr @ A1 @ Tr13 @ A32 ) ) ) ) ) ).

% inItr.cases
thf(fact_155_some__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ( P @ A2 )
     => ( ! [X3: A] :
            ( ( P @ X3 )
           => ( X3 = A2 ) )
       => ( ( ^ [P2: A > $o] :
              @+[X5: A] : ( P2 @ X5 )
            @ P )
          = A2 ) ) ) ).

% some_equality
thf(fact_156_some__eq__trivial,axiom,
    ! [A: $tType,X: A] :
      ( ( @+[Y3: A] : ( Y3 = X ) )
      = X ) ).

% some_eq_trivial
thf(fact_157_some__sym__eq__trivial,axiom,
    ! [A: $tType,X: A] :
      ( ( ^ [P2: A > $o] :
          @+[X5: A] : ( P2 @ X5 )
        @ ( ^ [Y5: A,Z: A] : ( Y5 = Z )
          @ X ) )
      = X ) ).

% some_sym_eq_trivial
thf(fact_158_someI,axiom,
    ! [A: $tType,P: A > $o,X: A] :
      ( ( P @ X )
     => ( P
        @ ( ^ [P2: A > $o] :
            @+[X5: A] : ( P2 @ X5 )
          @ P ) ) ) ).

% someI
thf(fact_159_tfl__some,axiom,
    ! [A: $tType,P3: A > $o,X6: A] :
      ( ( P3 @ X6 )
     => ( P3
        @ ( ^ [P2: A > $o] :
            @+[X5: A] : ( P2 @ X5 )
          @ P3 ) ) ) ).

% tfl_some
thf(fact_160_some1__equality,axiom,
    ! [A: $tType,P: A > $o,A2: A] :
      ( ? [X6: A] :
          ( ( P @ X6 )
          & ! [Y4: A] :
              ( ( P @ Y4 )
             => ( Y4 = X6 ) ) )
     => ( ( P @ A2 )
       => ( ( ^ [P2: A > $o] :
              @+[X5: A] : ( P2 @ X5 )
            @ P )
          = A2 ) ) ) ).

% some1_equality
thf(fact_161_some__eq__ex,axiom,
    ! [A: $tType,P: A > $o] :
      ( ( P
        @ ( ^ [P2: A > $o] :
            @+[X5: A] : ( P2 @ X5 )
          @ P ) )
      = ( ^ [P2: A > $o] :
          ? [X5: A] : ( P2 @ X5 )
        @ P ) ) ).

% some_eq_ex
thf(fact_162_someI2__bex,axiom,
    ! [A: $tType,A5: set @ A,P: A > $o,Q: A > $o] :
      ( ? [X6: A] :
          ( ( member @ A @ X6 @ A5 )
          & ( P @ X6 ) )
     => ( ! [X3: A] :
            ( ( ( member @ A @ X3 @ A5 )
              & ( P @ X3 ) )
           => ( Q @ X3 ) )
       => ( Q
          @ @+[X4: A] :
              ( ( member @ A @ X4 @ A5 )
              & ( P @ X4 ) ) ) ) ) ).

% someI2_bex
thf(fact_163_someI2__ex,axiom,
    ! [A: $tType,P: A > $o,Q: A > $o] :
      ( ? [X13: A] : ( P @ X13 )
     => ( ! [X3: A] :
            ( ( P @ X3 )
           => ( Q @ X3 ) )
       => ( Q
          @ ( ^ [P2: A > $o] :
              @+[X5: A] : ( P2 @ X5 )
            @ P ) ) ) ) ).

% someI2_ex
thf(fact_164_someI__ex,axiom,
    ! [A: $tType,P: A > $o] :
      ( ? [X13: A] : ( P @ X13 )
     => ( P
        @ ( ^ [P2: A > $o] :
            @+[X5: A] : ( P2 @ X5 )
          @ P ) ) ) ).

% someI_ex
thf(fact_165_someI2,axiom,
    ! [A: $tType,P: A > $o,A2: A,Q: A > $o] :
      ( ( P @ A2 )
     => ( ! [X3: A] :
            ( ( P @ X3 )
           => ( Q @ X3 ) )
       => ( Q
          @ ( ^ [P2: A > $o] :
              @+[X5: A] : ( P2 @ X5 )
            @ P ) ) ) ) ).

% someI2
thf(fact_166_pred__subset__eq,axiom,
    ! [A: $tType,R: set @ A,S: set @ A] :
      ( ( ord_less_eq @ ( A > $o )
        @ ^ [X4: A] : ( member @ A @ X4 @ R )
        @ ^ [X4: A] : ( member @ A @ X4 @ S ) )
      = ( ord_less_eq @ ( set @ A ) @ R @ S ) ) ).

% pred_subset_eq
thf(fact_167_Greatest__equality,axiom,
    ! [A: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [P: A > $o,K: A] :
          ( ( P @ K )
         => ( ! [X3: A] :
                ( ( P @ X3 )
               => ( ord_less_eq @ A @ X3 @ K ) )
           => ( ( hilbert_Greatest @ A @ P )
              = K ) ) ) ) ).

% Greatest_equality
thf(fact_168_subset__code_I3_J,axiom,
    ! [C2: $tType] :
      ~ ( ord_less_eq @ ( set @ C2 ) @ ( coset @ C2 @ ( nil @ C2 ) ) @ ( set2 @ C2 @ ( nil @ C2 ) ) ) ).

% subset_code(3)
thf(fact_169_subset__code_I2_J,axiom,
    ! [B: $tType,A5: set @ B,Ys3: list @ B] :
      ( ( ord_less_eq @ ( set @ B ) @ A5 @ ( coset @ B @ Ys3 ) )
      = ( ! [X4: B] :
            ( ( member @ B @ X4 @ ( set2 @ B @ Ys3 ) )
           => ~ ( member @ B @ X4 @ A5 ) ) ) ) ).

% subset_code(2)
thf(fact_170_Greatest__def,axiom,
    ! [A: $tType] :
      ( ( ord @ A @ ( type2 @ A ) )
     => ( ( hilbert_Greatest @ A )
        = ( hilbert_GreatestM @ A @ A
          @ ^ [X4: A] : X4 ) ) ) ).

% Greatest_def
thf(fact_171_Itr__def,axiom,
    ( gram_L1580978439le_Itr
    = ( ^ [Ns3: set @ n,Tr3: dtree] : ( collect @ n @ ( gram_L830233218_inItr @ Ns3 @ Tr3 ) ) ) ) ).

% Itr_def
thf(fact_172_not__in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ~ ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = ( cons @ A @ X @ Xs ) ) ) ).

% not_in_set_insert
thf(fact_173_in__set__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( member @ A @ X @ ( set2 @ A @ Xs ) )
     => ( ( insert @ A @ X @ Xs )
        = Xs ) ) ).

% in_set_insert
thf(fact_174_distinct__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( distinct @ A @ ( insert @ A @ X @ Xs ) )
      = ( distinct @ A @ Xs ) ) ).

% distinct_insert
thf(fact_175_insert__Nil,axiom,
    ! [A: $tType,X: A] :
      ( ( insert @ A @ X @ ( nil @ A ) )
      = ( cons @ A @ X @ ( nil @ A ) ) ) ).

% insert_Nil
thf(fact_176_GreatestMI2,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [P: A > $o,X: A,M: A > B,Q: A > $o] :
          ( ( P @ X )
         => ( ! [Y4: A] :
                ( ( P @ Y4 )
               => ( ord_less_eq @ B @ ( M @ Y4 ) @ ( M @ X ) ) )
           => ( ! [X3: A] :
                  ( ( P @ X3 )
                 => ( ! [Y6: A] :
                        ( ( P @ Y6 )
                       => ( ord_less_eq @ B @ ( M @ Y6 ) @ ( M @ X3 ) ) )
                   => ( Q @ X3 ) ) )
             => ( Q @ ( hilbert_GreatestM @ A @ B @ M @ P ) ) ) ) ) ) ).

% GreatestMI2
thf(fact_177_List_Oinsert__def,axiom,
    ! [A: $tType] :
      ( ( insert @ A )
      = ( ^ [X4: A,Xs3: list @ A] : ( if @ ( list @ A ) @ ( member @ A @ X4 @ ( set2 @ A @ Xs3 ) ) @ Xs3 @ ( cons @ A @ X4 @ Xs3 ) ) ) ) ).

% List.insert_def
thf(fact_178_GreatestM__equality,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [P: B > $o,K: B,M: B > A] :
          ( ( P @ K )
         => ( ! [X3: B] :
                ( ( P @ X3 )
               => ( ord_less_eq @ A @ ( M @ X3 ) @ ( M @ K ) ) )
           => ( ( M @ ( hilbert_GreatestM @ B @ A @ M @ P ) )
              = ( M @ K ) ) ) ) ) ).

% GreatestM_equality
thf(fact_179_remove__code_I2_J,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( remove @ A @ X @ ( coset @ A @ Xs ) )
      = ( coset @ A @ ( insert @ A @ X @ Xs ) ) ) ).

% remove_code(2)
thf(fact_180_conj__subset__def,axiom,
    ! [A: $tType,A5: set @ A,P: A > $o,Q: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ A5
        @ ( collect @ A
          @ ^ [X4: A] :
              ( ( P @ X4 )
              & ( Q @ X4 ) ) ) )
      = ( ( ord_less_eq @ ( set @ A ) @ A5 @ ( collect @ A @ P ) )
        & ( ord_less_eq @ ( set @ A ) @ A5 @ ( collect @ A @ Q ) ) ) ) ).

% conj_subset_def
thf(fact_181_prop__restrict,axiom,
    ! [A: $tType,X: A,Z4: set @ A,X7: set @ A,P: A > $o] :
      ( ( member @ A @ X @ Z4 )
     => ( ( ord_less_eq @ ( set @ A ) @ Z4
          @ ( collect @ A
            @ ^ [X4: A] :
                ( ( member @ A @ X4 @ X7 )
                & ( P @ X4 ) ) ) )
       => ( P @ X ) ) ) ).

% prop_restrict
thf(fact_182_member__remove,axiom,
    ! [A: $tType,X: A,Y: A,A5: set @ A] :
      ( ( member @ A @ X @ ( remove @ A @ Y @ A5 ) )
      = ( ( member @ A @ X @ A5 )
        & ( X != Y ) ) ) ).

% member_remove
thf(fact_183_Collect__restrict,axiom,
    ! [A: $tType,X7: set @ A,P: A > $o] :
      ( ord_less_eq @ ( set @ A )
      @ ( collect @ A
        @ ^ [X4: A] :
            ( ( member @ A @ X4 @ X7 )
            & ( P @ X4 ) ) )
      @ X7 ) ).

% Collect_restrict
thf(fact_184_subset__Collect__iff,axiom,
    ! [A: $tType,B4: set @ A,A5: set @ A,P: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ B4 @ A5 )
     => ( ( ord_less_eq @ ( set @ A ) @ B4
          @ ( collect @ A
            @ ^ [X4: A] :
                ( ( member @ A @ X4 @ A5 )
                & ( P @ X4 ) ) ) )
        = ( ! [X4: A] :
              ( ( member @ A @ X4 @ B4 )
             => ( P @ X4 ) ) ) ) ) ).

% subset_Collect_iff
thf(fact_185_subset__CollectI,axiom,
    ! [A: $tType,B4: set @ A,A5: set @ A,Q: A > $o,P: A > $o] :
      ( ( ord_less_eq @ ( set @ A ) @ B4 @ A5 )
     => ( ! [X3: A] :
            ( ( member @ A @ X3 @ B4 )
           => ( ( Q @ X3 )
             => ( P @ X3 ) ) )
       => ( ord_less_eq @ ( set @ A )
          @ ( collect @ A
            @ ^ [X4: A] :
                ( ( member @ A @ X4 @ B4 )
                & ( Q @ X4 ) ) )
          @ ( collect @ A
            @ ^ [X4: A] :
                ( ( member @ A @ X4 @ A5 )
                & ( P @ X4 ) ) ) ) ) ) ).

% subset_CollectI
thf(fact_186_LeastM__equality,axiom,
    ! [A: $tType,B: $tType] :
      ( ( order @ A @ ( type2 @ A ) )
     => ! [P: B > $o,K: B,M: B > A] :
          ( ( P @ K )
         => ( ! [X3: B] :
                ( ( P @ X3 )
               => ( ord_less_eq @ A @ ( M @ K ) @ ( M @ X3 ) ) )
           => ( ( M @ ( hilbert_LeastM @ B @ A @ M @ P ) )
              = ( M @ K ) ) ) ) ) ).

% LeastM_equality
thf(fact_187_LeastMI2,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ord @ B @ ( type2 @ B ) )
     => ! [P: A > $o,X: A,M: A > B,Q: A > $o] :
          ( ( P @ X )
         => ( ! [Y4: A] :
                ( ( P @ Y4 )
               => ( ord_less_eq @ B @ ( M @ X ) @ ( M @ Y4 ) ) )
           => ( ! [X3: A] :
                  ( ( P @ X3 )
                 => ( ! [Y6: A] :
                        ( ( P @ Y6 )
                       => ( ord_less_eq @ B @ ( M @ X3 ) @ ( M @ Y6 ) ) )
                   => ( Q @ X3 ) ) )
             => ( Q @ ( hilbert_LeastM @ A @ B @ M @ P ) ) ) ) ) ) ).

% LeastMI2
thf(fact_188_not__arg__cong__Inr,axiom,
    ! [B: $tType,A: $tType,X: A,Y: A] :
      ( ( X != Y )
     => ( ( sum_Inr @ A @ B @ X )
       != ( sum_Inr @ A @ B @ Y ) ) ) ).

% not_arg_cong_Inr
thf(fact_189_shift__def,axiom,
    ! [B: $tType,A: $tType] :
      ( ( bNF_Greatest_shift @ A @ B )
      = ( ^ [Lab: ( list @ A ) > B,K2: A,Kl: list @ A] : ( Lab @ ( cons @ A @ K2 @ Kl ) ) ) ) ).

% shift_def
thf(fact_190_univ__def,axiom,
    ! [A: $tType,B: $tType] :
      ( ( bNF_Greatest_univ @ B @ A )
      = ( ^ [F2: B > A,X8: set @ B] :
            ( F2
            @ @+[X4: B] : ( member @ B @ X4 @ X8 ) ) ) ) ).

% univ_def
thf(fact_191_inFr2_OInd,axiom,
    ! [Tr1: dtree,Tr: dtree,Ns1: set @ n,T2: t] :
      ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
     => ( ( gram_L805317441_inFr2 @ Ns1 @ Tr1 @ T2 )
       => ( gram_L805317441_inFr2 @ ( insert2 @ n @ ( root @ Tr ) @ Ns1 ) @ Tr @ T2 ) ) ) ).

% inFr2.Ind
thf(fact_192_subtr2_OStep,axiom,
    ! [Tr1: dtree,Ns: set @ n,Tr22: dtree,Tr32: dtree] :
      ( ( member @ n @ ( root @ Tr1 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr22 ) )
       => ( ( gram_L1283001940subtr2 @ Ns @ Tr22 @ Tr32 )
         => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr32 ) ) ) ) ).

% subtr2.Step
thf(fact_193_insert__absorb2,axiom,
    ! [A: $tType,X: A,A5: set @ A] :
      ( ( insert2 @ A @ X @ ( insert2 @ A @ X @ A5 ) )
      = ( insert2 @ A @ X @ A5 ) ) ).

% insert_absorb2
thf(fact_194_insert__iff,axiom,
    ! [A: $tType,A2: A,B2: A,A5: set @ A] :
      ( ( member @ A @ A2 @ ( insert2 @ A @ B2 @ A5 ) )
      = ( ( A2 = B2 )
        | ( member @ A @ A2 @ A5 ) ) ) ).

% insert_iff
thf(fact_195_insertCI,axiom,
    ! [A: $tType,A2: A,B4: set @ A,B2: A] :
      ( ( ~ ( member @ A @ A2 @ B4 )
       => ( A2 = B2 ) )
     => ( member @ A @ A2 @ ( insert2 @ A @ B2 @ B4 ) ) ) ).

% insertCI
thf(fact_196_insert__subset,axiom,
    ! [A: $tType,X: A,A5: set @ A,B4: set @ A] :
      ( ( ord_less_eq @ ( set @ A ) @ ( insert2 @ A @ X @ A5 ) @ B4 )
      = ( ( member @ A @ X @ B4 )
        & ( ord_less_eq @ ( set @ A ) @ A5 @ B4 ) ) ) ).

% insert_subset
thf(fact_197_list_Osimps_I15_J,axiom,
    ! [A: $tType,X21: A,X22: list @ A] :
      ( ( set2 @ A @ ( cons @ A @ X21 @ X22 ) )
      = ( insert2 @ A @ X21 @ ( set2 @ A @ X22 ) ) ) ).

% list.simps(15)
thf(fact_198_List_Oset__insert,axiom,
    ! [A: $tType,X: A,Xs: list @ A] :
      ( ( set2 @ A @ ( insert @ A @ X @ Xs ) )
      = ( insert2 @ A @ X @ ( set2 @ A @ Xs ) ) ) ).

% List.set_insert
thf(fact_199_insert__subsetI,axiom,
    ! [A: $tType,X: A,A5: set @ A,X7: set @ A] :
      ( ( member @ A @ X @ A5 )
     => ( ( ord_less_eq @ ( set @ A ) @ X7 @ A5 )
       => ( ord_less_eq @ ( set @ A ) @ ( insert2 @ A @ X @ X7 ) @ A5 ) ) ) ).

% insert_subsetI
thf(fact_200_subtr2__mono,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Ns2: set @ n] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( ( ord_less_eq @ ( set @ n ) @ Ns @ Ns2 )
       => ( gram_L1283001940subtr2 @ Ns2 @ Tr1 @ Tr22 ) ) ) ).

% subtr2_mono
thf(fact_201_insert__mono,axiom,
    ! [A: $tType,C3: set @ A,D: set @ A,A2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ C3 @ D )
     => ( ord_less_eq @ ( set @ A ) @ ( insert2 @ A @ A2 @ C3 ) @ ( insert2 @ A @ A2 @ D ) ) ) ).

% insert_mono
thf(fact_202_subset__insert,axiom,
    ! [A: $tType,X: A,A5: set @ A,B4: set @ A] :
      ( ~ ( member @ A @ X @ A5 )
     => ( ( ord_less_eq @ ( set @ A ) @ A5 @ ( insert2 @ A @ X @ B4 ) )
        = ( ord_less_eq @ ( set @ A ) @ A5 @ B4 ) ) ) ).

% subset_insert
thf(fact_203_subset__insertI,axiom,
    ! [A: $tType,B4: set @ A,A2: A] : ( ord_less_eq @ ( set @ A ) @ B4 @ ( insert2 @ A @ A2 @ B4 ) ) ).

% subset_insertI
thf(fact_204_subset__insertI2,axiom,
    ! [A: $tType,A5: set @ A,B4: set @ A,B2: A] :
      ( ( ord_less_eq @ ( set @ A ) @ A5 @ B4 )
     => ( ord_less_eq @ ( set @ A ) @ A5 @ ( insert2 @ A @ B2 @ B4 ) ) ) ).

% subset_insertI2
thf(fact_205_subtr2__trans,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree,Tr32: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( ( gram_L1283001940subtr2 @ Ns @ Tr22 @ Tr32 )
       => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr32 ) ) ) ).

% subtr2_trans
thf(fact_206_mk__disjoint__insert,axiom,
    ! [A: $tType,A2: A,A5: set @ A] :
      ( ( member @ A @ A2 @ A5 )
     => ? [B7: set @ A] :
          ( ( A5
            = ( insert2 @ A @ A2 @ B7 ) )
          & ~ ( member @ A @ A2 @ B7 ) ) ) ).

% mk_disjoint_insert
thf(fact_207_insert__commute,axiom,
    ! [A: $tType,X: A,Y: A,A5: set @ A] :
      ( ( insert2 @ A @ X @ ( insert2 @ A @ Y @ A5 ) )
      = ( insert2 @ A @ Y @ ( insert2 @ A @ X @ A5 ) ) ) ).

% insert_commute
thf(fact_208_insert__eq__iff,axiom,
    ! [A: $tType,A2: A,A5: set @ A,B2: A,B4: set @ A] :
      ( ~ ( member @ A @ A2 @ A5 )
     => ( ~ ( member @ A @ B2 @ B4 )
       => ( ( ( insert2 @ A @ A2 @ A5 )
            = ( insert2 @ A @ B2 @ B4 ) )
          = ( ( ( A2 = B2 )
             => ( A5 = B4 ) )
            & ( ( A2 != B2 )
             => ? [C4: set @ A] :
                  ( ( A5
                    = ( insert2 @ A @ B2 @ C4 ) )
                  & ~ ( member @ A @ B2 @ C4 )
                  & ( B4
                    = ( insert2 @ A @ A2 @ C4 ) )
                  & ~ ( member @ A @ A2 @ C4 ) ) ) ) ) ) ) ).

% insert_eq_iff
thf(fact_209_insert__absorb,axiom,
    ! [A: $tType,A2: A,A5: set @ A] :
      ( ( member @ A @ A2 @ A5 )
     => ( ( insert2 @ A @ A2 @ A5 )
        = A5 ) ) ).

% insert_absorb
thf(fact_210_insert__ident,axiom,
    ! [A: $tType,X: A,A5: set @ A,B4: set @ A] :
      ( ~ ( member @ A @ X @ A5 )
     => ( ~ ( member @ A @ X @ B4 )
       => ( ( ( insert2 @ A @ X @ A5 )
            = ( insert2 @ A @ X @ B4 ) )
          = ( A5 = B4 ) ) ) ) ).

% insert_ident
thf(fact_211_Set_Oset__insert,axiom,
    ! [A: $tType,X: A,A5: set @ A] :
      ( ( member @ A @ X @ A5 )
     => ~ ! [B7: set @ A] :
            ( ( A5
              = ( insert2 @ A @ X @ B7 ) )
           => ( member @ A @ X @ B7 ) ) ) ).

% Set.set_insert
thf(fact_212_insertI2,axiom,
    ! [A: $tType,A2: A,B4: set @ A,B2: A] :
      ( ( member @ A @ A2 @ B4 )
     => ( member @ A @ A2 @ ( insert2 @ A @ B2 @ B4 ) ) ) ).

% insertI2
thf(fact_213_insertI1,axiom,
    ! [A: $tType,A2: A,B4: set @ A] : ( member @ A @ A2 @ ( insert2 @ A @ A2 @ B4 ) ) ).

% insertI1
thf(fact_214_insertE,axiom,
    ! [A: $tType,A2: A,B2: A,A5: set @ A] :
      ( ( member @ A @ A2 @ ( insert2 @ A @ B2 @ A5 ) )
     => ( ( A2 != B2 )
       => ( member @ A @ A2 @ A5 ) ) ) ).

% insertE
thf(fact_215_insert__compr,axiom,
    ! [A: $tType] :
      ( ( insert2 @ A )
      = ( ^ [A3: A,B5: set @ A] :
            ( collect @ A
            @ ^ [X4: A] :
                ( ( X4 = A3 )
                | ( member @ A @ X4 @ B5 ) ) ) ) ) ).

% insert_compr
thf(fact_216_insert__Collect,axiom,
    ! [A: $tType,A2: A,P: A > $o] :
      ( ( insert2 @ A @ A2 @ ( collect @ A @ P ) )
      = ( collect @ A
        @ ^ [U: A] :
            ( ( U != A2 )
           => ( P @ U ) ) ) ) ).

% insert_Collect
thf(fact_217_subtr__subtr2,axiom,
    gram_L716654942_subtr = gram_L1283001940subtr2 ).

% subtr_subtr2
thf(fact_218_subtr2_ORefl,axiom,
    ! [Tr: dtree,Ns: set @ n] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( gram_L1283001940subtr2 @ Ns @ Tr @ Tr ) ) ).

% subtr2.Refl
thf(fact_219_subtr2__rootL__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr1 ) @ Ns ) ) ).

% subtr2_rootL_in
thf(fact_220_subtr2__rootR__in,axiom,
    ! [Ns: set @ n,Tr1: dtree,Tr22: dtree] :
      ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
     => ( member @ n @ ( root @ Tr22 ) @ Ns ) ) ).

% subtr2_rootR_in
thf(fact_221_subtr2_Oinducts,axiom,
    ! [X12: set @ n,X2: dtree,X32: dtree,P: ( set @ n ) > dtree > dtree > $o] :
      ( ( gram_L1283001940subtr2 @ X12 @ X2 @ X32 )
     => ( ! [Tr5: dtree,Ns4: set @ n] :
            ( ( member @ n @ ( root @ Tr5 ) @ Ns4 )
           => ( P @ Ns4 @ Tr5 @ Tr5 ) )
       => ( ! [Tr13: dtree,Ns4: set @ n,Tr23: dtree,Tr34: dtree] :
              ( ( member @ n @ ( root @ Tr13 ) @ Ns4 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr23 ) )
               => ( ( gram_L1283001940subtr2 @ Ns4 @ Tr23 @ Tr34 )
                 => ( ( P @ Ns4 @ Tr23 @ Tr34 )
                   => ( P @ Ns4 @ Tr13 @ Tr34 ) ) ) ) )
         => ( P @ X12 @ X2 @ X32 ) ) ) ) ).

% subtr2.inducts
thf(fact_222_subtr2__StepR,axiom,
    ! [Tr32: dtree,Ns: set @ n,Tr22: dtree,Tr1: dtree] :
      ( ( member @ n @ ( root @ Tr32 ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr22 ) @ ( cont @ Tr32 ) )
       => ( ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr22 )
         => ( gram_L1283001940subtr2 @ Ns @ Tr1 @ Tr32 ) ) ) ) ).

% subtr2_StepR
thf(fact_223_subtr2_Osimps,axiom,
    ( gram_L1283001940subtr2
    = ( ^ [A12: set @ n,A23: dtree,A33: dtree] :
          ( ? [Tr3: dtree,Ns3: set @ n] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr3 )
              & ( A33 = Tr3 )
              & ( member @ n @ ( root @ Tr3 ) @ Ns3 ) )
          | ? [Tr12: dtree,Ns3: set @ n,Tr24: dtree,Tr33: dtree] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr12 )
              & ( A33 = Tr33 )
              & ( member @ n @ ( root @ Tr12 ) @ Ns3 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr24 ) )
              & ( gram_L1283001940subtr2 @ Ns3 @ Tr24 @ Tr33 ) ) ) ) ) ).

% subtr2.simps
thf(fact_224_subtr2_Ocases,axiom,
    ! [A1: set @ n,A22: dtree,A32: dtree] :
      ( ( gram_L1283001940subtr2 @ A1 @ A22 @ A32 )
     => ( ( ( A32 = A22 )
         => ~ ( member @ n @ ( root @ A22 ) @ A1 ) )
       => ~ ( ( member @ n @ ( root @ A22 ) @ A1 )
           => ! [Tr23: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ A22 ) @ ( cont @ Tr23 ) )
               => ~ ( gram_L1283001940subtr2 @ A1 @ Tr23 @ A32 ) ) ) ) ) ).

% subtr2.cases
thf(fact_225_inFr__Ind__minus,axiom,
    ! [Ns1: set @ n,Tr1: dtree,T2: t,Tr: dtree] :
      ( ( gram_L1333338417e_inFr @ Ns1 @ Tr1 @ T2 )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( gram_L1333338417e_inFr @ ( insert2 @ n @ ( root @ Tr ) @ Ns1 ) @ Tr @ T2 ) ) ) ).

% inFr_Ind_minus
thf(fact_226_inFr2_Ocases,axiom,
    ! [A1: set @ n,A22: dtree,A32: t] :
      ( ( gram_L805317441_inFr2 @ A1 @ A22 @ A32 )
     => ( ( ( member @ n @ ( root @ A22 ) @ A1 )
         => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ A32 ) @ ( cont @ A22 ) ) )
       => ~ ! [Tr13: dtree,Tr5: dtree,Ns12: set @ n] :
              ( ( A1
                = ( insert2 @ n @ ( root @ Tr5 ) @ Ns12 ) )
             => ( ( A22 = Tr5 )
               => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr5 ) )
                 => ~ ( gram_L805317441_inFr2 @ Ns12 @ Tr13 @ A32 ) ) ) ) ) ) ).

% inFr2.cases
thf(fact_227_sum_Oinject_I1_J,axiom,
    ! [B: $tType,A: $tType,X12: A,Y1: A] :
      ( ( ( sum_Inl @ A @ B @ X12 )
        = ( sum_Inl @ A @ B @ Y1 ) )
      = ( X12 = Y1 ) ) ).

% sum.inject(1)
thf(fact_228_old_Osum_Oinject_I1_J,axiom,
    ! [B: $tType,A: $tType,A2: A,A7: A] :
      ( ( ( sum_Inl @ A @ B @ A2 )
        = ( sum_Inl @ A @ B @ A7 ) )
      = ( A2 = A7 ) ) ).

% old.sum.inject(1)
thf(fact_229_old_Osum_Osimps_I7_J,axiom,
    ! [B: $tType,T: $tType,A: $tType,F1: A > T,F22: B > T,A2: A] :
      ( ( sum_rec_sum @ A @ T @ B @ F1 @ F22 @ ( sum_Inl @ A @ B @ A2 ) )
      = ( F1 @ A2 ) ) ).

% old.sum.simps(7)
thf(fact_230_obj__sumE,axiom,
    ! [A: $tType,B: $tType,S2: sum_sum @ A @ B] :
      ( ! [X3: A] :
          ( S2
         != ( sum_Inl @ A @ B @ X3 ) )
     => ~ ! [X3: B] :
            ( S2
           != ( sum_Inr @ B @ A @ X3 ) ) ) ).

% obj_sumE
thf(fact_231_inFr__mono,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t,Ns2: set @ n] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ( ( ord_less_eq @ ( set @ n ) @ Ns @ Ns2 )
       => ( gram_L1333338417e_inFr @ Ns2 @ Tr @ T2 ) ) ) ).

% inFr_mono
thf(fact_232_subtr__inFr,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t,Tr1: dtree] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ( ( gram_L716654942_subtr @ Ns @ Tr @ Tr1 )
       => ( gram_L1333338417e_inFr @ Ns @ Tr1 @ T2 ) ) ) ).

% subtr_inFr
thf(fact_233_inFr_Oinducts,axiom,
    ! [X12: set @ n,X2: dtree,X32: t,P: ( set @ n ) > dtree > t > $o] :
      ( ( gram_L1333338417e_inFr @ X12 @ X2 @ X32 )
     => ( ! [Tr5: dtree,Ns4: set @ n,T4: t] :
            ( ( member @ n @ ( root @ Tr5 ) @ Ns4 )
           => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T4 ) @ ( cont @ Tr5 ) )
             => ( P @ Ns4 @ Tr5 @ T4 ) ) )
       => ( ! [Tr5: dtree,Ns4: set @ n,Tr13: dtree,T4: t] :
              ( ( member @ n @ ( root @ Tr5 ) @ Ns4 )
             => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr5 ) )
               => ( ( gram_L1333338417e_inFr @ Ns4 @ Tr13 @ T4 )
                 => ( ( P @ Ns4 @ Tr13 @ T4 )
                   => ( P @ Ns4 @ Tr5 @ T4 ) ) ) ) )
         => ( P @ X12 @ X2 @ X32 ) ) ) ) ).

% inFr.inducts
thf(fact_234_inFr_Osimps,axiom,
    ( gram_L1333338417e_inFr
    = ( ^ [A12: set @ n,A23: dtree,A33: t] :
          ( ? [Tr3: dtree,Ns3: set @ n,T3: t] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr3 )
              & ( A33 = T3 )
              & ( member @ n @ ( root @ Tr3 ) @ Ns3 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T3 ) @ ( cont @ Tr3 ) ) )
          | ? [Tr3: dtree,Ns3: set @ n,Tr12: dtree,T3: t] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr3 )
              & ( A33 = T3 )
              & ( member @ n @ ( root @ Tr3 ) @ Ns3 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr3 ) )
              & ( gram_L1333338417e_inFr @ Ns3 @ Tr12 @ T3 ) ) ) ) ) ).

% inFr.simps
thf(fact_235_inFr_Ocases,axiom,
    ! [A1: set @ n,A22: dtree,A32: t] :
      ( ( gram_L1333338417e_inFr @ A1 @ A22 @ A32 )
     => ( ( ( member @ n @ ( root @ A22 ) @ A1 )
         => ~ ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ A32 ) @ ( cont @ A22 ) ) )
       => ~ ( ( member @ n @ ( root @ A22 ) @ A1 )
           => ! [Tr13: dtree] :
                ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ A22 ) )
               => ~ ( gram_L1333338417e_inFr @ A1 @ Tr13 @ A32 ) ) ) ) ) ).

% inFr.cases
thf(fact_236_Inl__inject,axiom,
    ! [B: $tType,A: $tType,X: A,Y: A] :
      ( ( ( sum_Inl @ A @ B @ X )
        = ( sum_Inl @ A @ B @ Y ) )
     => ( X = Y ) ) ).

% Inl_inject
thf(fact_237_not__root__inFr,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ~ ( member @ n @ ( root @ Tr ) @ Ns )
     => ~ ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ).

% not_root_inFr
thf(fact_238_inFr__root__in,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ( member @ n @ ( root @ Tr ) @ Ns ) ) ).

% inFr_root_in
thf(fact_239_inFr__subtr,axiom,
    ! [Ns: set @ n,Tr: dtree,T2: t] :
      ( ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 )
     => ? [Tr6: dtree] :
          ( ( gram_L716654942_subtr @ Ns @ Tr6 @ Tr )
          & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr6 ) ) ) ) ).

% inFr_subtr
thf(fact_240_inFr_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr ) )
       => ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ) ).

% inFr.Base
thf(fact_241_old_Osum_Oinducts,axiom,
    ! [B: $tType,A: $tType,P: ( sum_sum @ A @ B ) > $o,Sum: sum_sum @ A @ B] :
      ( ! [A4: A] : ( P @ ( sum_Inl @ A @ B @ A4 ) )
     => ( ! [B6: B] : ( P @ ( sum_Inr @ B @ A @ B6 ) )
       => ( P @ Sum ) ) ) ).

% old.sum.inducts
thf(fact_242_old_Osum_Oexhaust,axiom,
    ! [A: $tType,B: $tType,Y: sum_sum @ A @ B] :
      ( ! [A4: A] :
          ( Y
         != ( sum_Inl @ A @ B @ A4 ) )
     => ~ ! [B6: B] :
            ( Y
           != ( sum_Inr @ B @ A @ B6 ) ) ) ).

% old.sum.exhaust
thf(fact_243_split__sum__all,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ^ [P2: ( sum_sum @ A @ B ) > $o] :
          ! [X5: sum_sum @ A @ B] : ( P2 @ X5 ) )
      = ( ^ [P4: ( sum_sum @ A @ B ) > $o] :
            ( ! [X4: A] : ( P4 @ ( sum_Inl @ A @ B @ X4 ) )
            & ! [X4: B] : ( P4 @ ( sum_Inr @ B @ A @ X4 ) ) ) ) ) ).

% split_sum_all
thf(fact_244_split__sum__ex,axiom,
    ! [B: $tType,A: $tType] :
      ( ( ^ [P2: ( sum_sum @ A @ B ) > $o] :
          ? [X5: sum_sum @ A @ B] : ( P2 @ X5 ) )
      = ( ^ [P4: ( sum_sum @ A @ B ) > $o] :
            ( ? [X4: A] : ( P4 @ ( sum_Inl @ A @ B @ X4 ) )
            | ? [X4: B] : ( P4 @ ( sum_Inr @ B @ A @ X4 ) ) ) ) ) ).

% split_sum_ex
thf(fact_245_Inr__not__Inl,axiom,
    ! [B: $tType,A: $tType,B2: B,A2: A] :
      ( ( sum_Inr @ B @ A @ B2 )
     != ( sum_Inl @ A @ B @ A2 ) ) ).

% Inr_not_Inl
thf(fact_246_sumE,axiom,
    ! [A: $tType,B: $tType,S2: sum_sum @ A @ B] :
      ( ! [X3: A] :
          ( S2
         != ( sum_Inl @ A @ B @ X3 ) )
     => ~ ! [Y4: B] :
            ( S2
           != ( sum_Inr @ B @ A @ Y4 ) ) ) ).

% sumE
thf(fact_247_old_Osum_Odistinct_I1_J,axiom,
    ! [A: $tType,B: $tType,A2: A,B3: B] :
      ( ( sum_Inl @ A @ B @ A2 )
     != ( sum_Inr @ B @ A @ B3 ) ) ).

% old.sum.distinct(1)
thf(fact_248_old_Osum_Odistinct_I2_J,axiom,
    ! [B8: $tType,A8: $tType,B9: B8,A9: A8] :
      ( ( sum_Inr @ B8 @ A8 @ B9 )
     != ( sum_Inl @ A8 @ B8 @ A9 ) ) ).

% old.sum.distinct(2)
thf(fact_249_sum_Odistinct_I1_J,axiom,
    ! [A: $tType,B: $tType,X12: A,X2: B] :
      ( ( sum_Inl @ A @ B @ X12 )
     != ( sum_Inr @ B @ A @ X2 ) ) ).

% sum.distinct(1)
thf(fact_250_inFr__inFr2,axiom,
    gram_L1333338417e_inFr = gram_L805317441_inFr2 ).

% inFr_inFr2
thf(fact_251_inFr2_OBase,axiom,
    ! [Tr: dtree,Ns: set @ n,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T2 ) @ ( cont @ Tr ) )
       => ( gram_L805317441_inFr2 @ Ns @ Tr @ T2 ) ) ) ).

% inFr2.Base
thf(fact_252_inFr_OInd,axiom,
    ! [Tr: dtree,Ns: set @ n,Tr1: dtree,T2: t] :
      ( ( member @ n @ ( root @ Tr ) @ Ns )
     => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr1 ) @ ( cont @ Tr ) )
       => ( ( gram_L1333338417e_inFr @ Ns @ Tr1 @ T2 )
         => ( gram_L1333338417e_inFr @ Ns @ Tr @ T2 ) ) ) ) ).

% inFr.Ind
thf(fact_253_inFr2_Oinducts,axiom,
    ! [X12: set @ n,X2: dtree,X32: t,P: ( set @ n ) > dtree > t > $o] :
      ( ( gram_L805317441_inFr2 @ X12 @ X2 @ X32 )
     => ( ! [Tr5: dtree,Ns4: set @ n,T4: t] :
            ( ( member @ n @ ( root @ Tr5 ) @ Ns4 )
           => ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T4 ) @ ( cont @ Tr5 ) )
             => ( P @ Ns4 @ Tr5 @ T4 ) ) )
       => ( ! [Tr13: dtree,Tr5: dtree,Ns12: set @ n,T4: t] :
              ( ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr13 ) @ ( cont @ Tr5 ) )
             => ( ( gram_L805317441_inFr2 @ Ns12 @ Tr13 @ T4 )
               => ( ( P @ Ns12 @ Tr13 @ T4 )
                 => ( P @ ( insert2 @ n @ ( root @ Tr5 ) @ Ns12 ) @ Tr5 @ T4 ) ) ) )
         => ( P @ X12 @ X2 @ X32 ) ) ) ) ).

% inFr2.inducts
thf(fact_254_inFr2_Osimps,axiom,
    ( gram_L805317441_inFr2
    = ( ^ [A12: set @ n,A23: dtree,A33: t] :
          ( ? [Tr3: dtree,Ns3: set @ n,T3: t] :
              ( ( A12 = Ns3 )
              & ( A23 = Tr3 )
              & ( A33 = T3 )
              & ( member @ n @ ( root @ Tr3 ) @ Ns3 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inl @ t @ dtree @ T3 ) @ ( cont @ Tr3 ) ) )
          | ? [Tr12: dtree,Tr3: dtree,Ns13: set @ n,T3: t] :
              ( ( A12
                = ( insert2 @ n @ ( root @ Tr3 ) @ Ns13 ) )
              & ( A23 = Tr3 )
              & ( A33 = T3 )
              & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ Tr12 ) @ ( cont @ Tr3 ) )
              & ( gram_L805317441_inFr2 @ Ns13 @ Tr12 @ T3 ) ) ) ) ) ).

% inFr2.simps

%----Type constructors (10)
thf(tcon_fun___Orderings_Opreorder,axiom,
    ! [A8: $tType,A10: $tType] :
      ( ( preorder @ A10 @ ( type2 @ A10 ) )
     => ( preorder @ ( A8 > A10 ) @ ( type2 @ ( A8 > A10 ) ) ) ) ).

thf(tcon_fun___Orderings_Oorder,axiom,
    ! [A8: $tType,A10: $tType] :
      ( ( order @ A10 @ ( type2 @ A10 ) )
     => ( order @ ( A8 > A10 ) @ ( type2 @ ( A8 > A10 ) ) ) ) ).

thf(tcon_fun___Orderings_Oord,axiom,
    ! [A8: $tType,A10: $tType] :
      ( ( ord @ A10 @ ( type2 @ A10 ) )
     => ( ord @ ( A8 > A10 ) @ ( type2 @ ( A8 > A10 ) ) ) ) ).

thf(tcon_Set_Oset___Orderings_Opreorder_1,axiom,
    ! [A8: $tType] : ( preorder @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oorder_2,axiom,
    ! [A8: $tType] : ( order @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_Set_Oset___Orderings_Oord_3,axiom,
    ! [A8: $tType] : ( ord @ ( set @ A8 ) @ ( type2 @ ( set @ A8 ) ) ) ).

thf(tcon_HOL_Obool___Orderings_Opreorder_4,axiom,
    preorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Olinorder,axiom,
    linorder @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oorder_5,axiom,
    order @ $o @ ( type2 @ $o ) ).

thf(tcon_HOL_Obool___Orderings_Oord_6,axiom,
    ord @ $o @ ( type2 @ $o ) ).

%----Helper facts (3)
thf(help_If_3_1_T,axiom,
    ! [P: $o] :
      ( ( P = $true )
      | ( P = $false ) ) ).

thf(help_If_2_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $false @ X @ Y )
      = Y ) ).

thf(help_If_1_1_T,axiom,
    ! [A: $tType,X: A,Y: A] :
      ( ( if @ A @ $true @ X @ Y )
      = X ) ).

%----Conjectures (1)
thf(conj_0,conjecture,
    ( ? [N4: n] :
        ( ( cons @ n @ ( root @ tra ) @ nl )
        = ( cons @ n @ N4 @ ( nil @ n ) ) )
    | ? [N14: n,Nl5: list @ n,N4: n] :
        ( ( ( cons @ n @ ( root @ tra ) @ nl )
          = ( cons @ n @ N4 @ ( cons @ n @ N14 @ Nl5 ) ) )
        & ( gram_L250615845e_path @ f @ ( cons @ n @ N14 @ Nl5 ) )
        & ( member @ ( sum_sum @ t @ dtree ) @ ( sum_Inr @ dtree @ t @ ( f @ N14 ) ) @ ( cont @ ( f @ N4 ) ) ) ) ) ).

%------------------------------------------------------------------------------
